package w83b.w83bBeans;



import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;

import w83b.util.jdbc.W83bDataBase;
import w83b.w83bDAO.w83bConstantesBD.W83bFasesBD;
import w83b.w83bDAO.w83bConstantesBD.W83bPlantillasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bTramitesBD;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;



/*
 * @author jrgil 
 */
public class W83bPlantillasBean extends W83bBaseBean implements W83bBaseBeanBD{
	private static final long	serialVersionUID	= 1L;

	private String	idPlantilla = "";
	private String	idTramite = "";
	private String  descTramite = "";
	private String  descTramiteEusk = "";
	private String	idFase = "";
	private String  descFase = "";
	private String  descFaseEusk = "";
	private String	nombrePlantilla = "";
	private String	descripcion = "";
	private String  descripcion_eusk = "";	
	private byte[] fichero;
	private Blob ficheroRecibido;
	private String nombreFichero = "";

	public String getIdPlantilla() {
		return idPlantilla;
	}

	public void setIdPlantilla(String idPlantilla) {
		this.idPlantilla = idPlantilla;
	}

	public String getIdTramite() {
		return idTramite;
	}

	public void setIdTramite(String idTramite) {
		this.idTramite = idTramite;
	}

	public String getIdFase() {
		return idFase;
	}

	public void setIdFase(String idFase) {
		this.idFase = idFase;
	}

	public String getDescTramite() {
		return descTramite;
	}

	public void setDescTramite(String descTramite) {
		this.descTramite = descTramite;
	}

	public String getDescFase() {
		return descFase;
	}

	public void setDescFase(String descFase) {
		this.descFase = descFase;
	}

	public String getNombrePlantilla() {
		return nombrePlantilla;
	}

	public void setNombrePlantilla(String nombrePlantilla) {
		this.nombrePlantilla = nombrePlantilla;
	}

	public String getDescripcion() {
		return descripcion;
	}

	public void setDescripcion(String descripcion) {
		this.descripcion = descripcion;
	}

	public String getDescripcion_eusk() {
		return descripcion_eusk;
	}

	public void setDescripcion_eusk(String descripcion_eusk) {
		this.descripcion_eusk = descripcion_eusk;
	}
	
	public void setDescTramiteEusk(String descTramiteEusk) {
		this.descTramiteEusk = descTramiteEusk;
	}

	public String getDescTramiteEusk() {
		return descTramiteEusk;
	}

	public void setDescFaseEusk(String descFaseEusk) {
		this.descFaseEusk = descFaseEusk;
	}

	public String getDescFaseEusk() {
		return descFaseEusk;
	}

	public String getPlantTramFase(){
		return this.idPlantilla+"__"+this.idTramite+"__"+this.idFase;
	}	

	public void setPlantTramFase(String claves){
		String[] arrayIds = claves.split("__");
		
		this.idPlantilla = arrayIds[0];
		this.idTramite = arrayIds[1];
		this.idFase = arrayIds[2];
	}

	public void setFichero(byte[] fichero) {
		this.fichero = fichero;
	}

	public byte[] getFichero() {
		return fichero;
	}

	public void setFicheroRecibido(Blob ficheroRecibido) {
		this.ficheroRecibido = ficheroRecibido;
	}

	public Blob getFicheroRecibido() {
		return ficheroRecibido;
	}

	public void setNombreFichero(String nombreFichero) {
		this.nombreFichero = nombreFichero;
	}

	public String getNombreFichero() {
		return nombreFichero;
	}
	
	public byte[] getFicheroRecibidoByte(){
		try {
			InputStream is;
				is = ficheroRecibido.getBinaryStream();
			ByteArrayOutputStream buffer = new ByteArrayOutputStream();
	
			int nRead;
			byte[] data = new byte[4096];
	
			while ((nRead = is.read(data, 0, data.length)) != -1) {
			  buffer.write(data, 0, nRead);
			}
	
			buffer.flush();
	
			return buffer.toByteArray();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}

	public Object rowToBean(Object o, Object otrosValores) throws SQLException, Q70GestorMensajesException {
		// TODO Auto-generated method stub
		// TODO Auto-generated method stub
		ResultSet rs= (ResultSet)o;//NOPMD
		this.idPlantilla = W83bDataBase.getStringFromRS(rs, W83bPlantillasBD.idPlantilla);
		this.idTramite = W83bDataBase.getStringFromRS(rs, W83bPlantillasBD.idTramite);
		this.descTramite = W83bDataBase.getStringFromRS(rs, W83bTramitesBD.descripcion);
		this.descTramiteEusk = W83bDataBase.getStringFromRS(rs, W83bTramitesBD.descripcion_eusk);
		this.idFase = W83bDataBase.getStringFromRS(rs, W83bPlantillasBD.idFase);
		this.descFase = W83bDataBase.getStringFromRS(rs, W83bFasesBD.descripcion);
		this.setDescFaseEusk(W83bDataBase.getStringFromRS(rs, W83bFasesBD.descripcion_eusk));
		this.nombrePlantilla = W83bDataBase.getStringFromRS(rs, W83bPlantillasBD.nombrePlantilla).toUpperCase();
		this.descripcion = W83bDataBase.getStringFromRS(rs, W83bPlantillasBD.descripcion);
		this.descripcion_eusk = W83bDataBase.getStringFromRS(rs, W83bPlantillasBD.descripcion_eusk);
		this.ficheroRecibido=W83bDataBase.getBlobFromRS(rs, W83bPlantillasBD.fichero);
		
		this.fichero = getFicheroRecibidoByte();
		
		return this;
	}

	


	
}
